#Germination test summary visualisation

# Import data -------------------------------------------------------------
#need to set working directory
#setwd()
source("02 data analysis.R") #the output of that script is full_summary2
all_data <- full_summary2

# packages
library(ggplot2)
library(tidyverse)
library(ggpubr)
library(ggrepel)

#Prep data
all_data$Ger_var <- "Affected"
all_data$Ger_var[(all_data$Ger_energy  == 'unaffected') &
                   (all_data$Ger_capacity  == 'unaffected')]    <- "Not affected"

#Keep only one bioassay per crop
all_data <- all_data[!(all_data$BioassayType=="Onion_Phoma" |
                         all_data$BioassayType=="Spinach_Fusarium" |
                         all_data$BioassayType=="Pepper plants_Phytophthora capsici" | 
                         all_data$BioassayType=="Perennial ryegrass_Laetisaria fuciformis"),]

dataa <- all_data[,c(1, 4, 5, 14)]
dataa$Row1 <- 1
x1<- dataa%>%
  group_by(BioassayType, Ger_var)%>%
  summarise(Frequency = sum(Row1))
df5 <- x1
head(df5)

split_data <- data.frame(str_split_fixed(df5$BioassayType, '_', 2))
colnames(split_data) <- c('Crop', 'Pathogen')
df5$BioassayType<- paste(split_data$Crop, '-', split_data$Pathogen)

df5 <- data.frame(df5, split_data)
df5$Crop[which(df5$Crop=='Pepper seedlings')] <- 'Pepper'
df5$Crop[which(df5$Crop=='Pepper seeds')] <- 'Pepper'

df5$Variable <- 'Germination'
df5$Frequency <- as.numeric(df5$Frequency)

c <- ggballoonplot(df5, x = "Ger_var", y = "Crop", fill = "Ger_var", 
                   ggtheme = theme_bw()) +
  geom_label_repel(aes(label = Frequency), size = 3.5,
                   box.padding   = 0.01,
                   point.padding = 0.01,
                   segment.color = "black",
                   nudge_x = 0.2, nudge_y = 0.2, 
                   min.segment.length = Inf) + 
  labs(size="Number of /n seed lots") + 
  guides(fill='none') +
  theme(axis.text.x=element_text(size=rel(1.3), angle = 35, colour="black"), 
        axis.text.y=element_text(size=rel(1.3), colour="black"), 
        strip.text.x = element_text(size=rel(1.5), colour="black"),
        plot.margin=unit(c(1, 4, 1, 4),"cm"),
        legend.position='none') +
  scale_fill_grey(start = 0.8, end = 0.3) 


c + scale_y_discrete(limits = c("Perennial ryegrass",
                              "Red fescue",
                              "Pepper",
                              "Coriander",         
                              "Spinach",
                              "Onion",                     
                              "Beetroot"))

#saved as pdf (landscape) 6.04 x 4.34